#ifndef __DM_COLLECTION_H__
#define __DM_COLLECTION_H__

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif
typedef struct
{
    UINT32 maxItems;
    UINT32 itemCnt;
    UINT32 itemBytes;
    UINT8 * pData;
} COLLECTION;

extern void CollectionCreate(COLLECTION * pc, UINT32 maxItems, UINT32 itemBytes, UINT8 * pData);
extern void * CollectionGetFirst(COLLECTION * pc, UINT32 * pIdx);
extern void * CollectionGetNext(COLLECTION * pc, UINT32 * pIdx);
extern void * CollectionGetAt(COLLECTION * pc, UINT32 i);
extern void * CollectionMakeNewItem(COLLECTION * pc, UINT32 * pIdx);

#ifdef __cplusplus
}
#endif

#endif  //__DM_COLLECTION_H__

